﻿/*	AVAILABLE DATA
	thisCommand_obj
		data						This command's data
		run()						This function
		nextEvent()			Function that triggers the next sibling command
		moveTimeout			Array + Functions to manage this command's timeout ID   (used to stop the script)
*/
#include "functions/once.as"
// run()
define_moveRelative = function( thisCommand_obj ){
	
	
	var prom = VOW.make();
	var nextEvent = once( prom.keep );		// calling nextEvent() calls prom.keep( true )
	
	
	if(TRACE_SCRIPT)
		trace("moveRelative");
	
	
	var duration = thisCommand_obj.data.duration;
	
	
	// apply autoDirection
	// assume strings are variable paths, and add brackets if they're missing
	if(typeof(thisCommand_obj.data.position.x)=="string")
		if(thisCommand_obj.data.position.x.charAt(0)!="[")
			thisCommand_obj.data.position.x = "["+thisCommand_obj.data.position.x+"]";
	if(typeof(thisCommand_obj.data.position.y)=="string")
		if(thisCommand_obj.data.position.y.charAt(0)!="[")
			thisCommand_obj.data.position.y = "["+thisCommand_obj.data.position.y+"]";
	
	// get direction traveled
	var xDist = Number( nestedEval( thisCommand_obj.data.position.x, "RAM", "_this" ) );
	var yDist = Number( nestedEval( thisCommand_obj.data.position.y, "RAM", "_this" ) );
	//var xDist = thisCommand_obj.data.position.x;
	//var yDist = thisCommand_obj.data.position.y;
	
	
	// check for walls
	if(TRACE_SCRIPT)
		trace(" hitWalls: " + thisCommand_obj.data.hitWalls);
	
	if( thisCommand_obj.data.hitWalls ){
		var tileSize = MAP.tileSize || 16;
		var xDir = xDist / Math.abs( xDist ) || 0;
		var yDir = yDist / Math.abs( yDist ) || 0;
		// check each tile along the path for a collision value > 0
		// // divide the vector into 16px (tileSize) chunks that center on tiles
		// // // figure out chunk size
		var path_p  = new flash.geom.Point( xDist,  yDist );
		var chunkSize_p = new flash.geom.Point();
		
		// process to reverse the length formula
		// ("length squared"  -  "tileSize squared"  =  "remaining side squared")  Then take the square root of the "remaining side squared" to get the "remaining side"
		// var remainingSide = (path_p.length * path_p.length)  -  tileSize * tileSize);
		var remainingSide = path_p.length  -  tileSize;
		if( path_p.x === 0 || path_p.y === 0 )		remainingSide = 0;
		remainingSide = Math.sqrt( remainingSide );
		if( Math.abs(xDist) > Math.abs(yDist) ){
			// horizontal orientation
			chunkSize_p.x = tileSize;
			chunkSize_p.y = remainingSide;
		}else{
			// vertical orientation
			chunkSize_p.x = remainingSide;
			chunkSize_p.y = tileSize;
		}
		chunkSize_p.x *= xDir;
		chunkSize_p.y *= yDir;
		var numChunks = Math.round( path_p.length / chunkSize_p.length );		// floor = ignore minor wall overlap,   ceil = prevent even a slight wall overlap,  round = happy medium?
		if( chunkSize_p.length === 0 )
			numChunks = 0;
		// trace(" numChunks: " + numChunks);
		// for each:  chunk
		var xStartPix = thisCommand_obj.sprite._x;
		var yStartPix = thisCommand_obj.sprite._y;
		var collisionData = MAP.collision_array;
		// start at index 1 to ignore the ground you're standing on,  allowing characters to walk out of walls onto floors
		for( var c=0; c<numChunks; c++){
			var index = c+1;
			var xCheckPix = (chunkSize_p.x * index) + xStartPix;
			var yCheckPix = (chunkSize_p.y * index) + yStartPix;
			var xCheckTile = Math.floor( xCheckPix / tileSize );
			var yCheckTile = Math.floor( yCheckPix / tileSize );
			// check the xtile and ytile value for each chunk
			var collisionValue = collisionData[ xCheckTile ][ yCheckTile ];
			if(TRACE_SCRIPT)
				trace(" #" + c + "  ("+xCheckTile+", "+yCheckTile+")  collisionValue: " + collisionValue);
			// if:  a wall is found,  then stop here.  The index will indicate how far this got
			if( collisionValue > 0 )
				break;
			// don't exit the map either
			if( collisionValue === undefined )
				break;
		}// for each:  chunk

		// overwrite the xDist and yDist values to their last non-colliding values
		// if:  some checks failed,  clip the path to the valid length
		if( c < numChunks ){
			var index = c-1;
			if( index < 0 )
				index = 0;
			xDist = index * chunkSize_p.x;
			yDist = index * chunkSize_p.y;
			// scaling duration down relative to the new distance
			var oldLength = path_p.length;
			path_p.x = xDist;
			path_p.y = yDist;
			var newLength = path_p.length;
			if( newLength > 0 ){
				var durationScale = newLength / oldLength;
				duration *= durationScale;
			}else{
				duration = 0;
			}
		}
		// if:  all checks passed (c === numChunks),  leave the path alone
			// do nothing
	}// if:  hit walls
	
	
	if(thisCommand_obj.data.autoDirection)
	{
		// compare x & y
		if( Math.abs(yDist) > Math.abs(xDist) ){// vert
			if( yDist < 0){// up
				thisCommand_obj.sprite.image.setParams({direction:"up"});
			}else{// down
				thisCommand_obj.sprite.image.setParams({direction:"down"});
			}// if:  up or down
		}else{// horz
			if( xDist < 0 ){// left
				thisCommand_obj.sprite.image.setParams({direction:"left"});
			}else{// right
				thisCommand_obj.sprite.image.setParams({direction:"right"});
			}// if:  left or right
		}// if:  vert or horz
	}// if:  autoDirection
	
	
	
	// apply autoAnim
	if(thisCommand_obj.data.autoAnim)
		thisCommand_obj.sprite.image.setParams({isAnimating:true});
	
	
	
	// prepare to move
	var startX = thisCommand_obj.sprite._x;
	var startY = thisCommand_obj.sprite._y;
	var endX = startX + xDist;
	var endY = startY + yDist;
	
	
	
	// if:   no duration
	// instantly done
	if(duration == 0){
		// jump to destination
		thisCommand_obj.sprite._x = endX;
		thisCommand_obj.sprite._y = endY;
		// stop animating
		if(thisCommand_obj.data.autoAnim)		// ON
			thisCommand_obj.sprite.image.setParams({isAnimating:false});
		// finish instantly
		return VOW.make().keep();
	}// if:   no duration
	
	
	
	// slide position
	var react_to_unload = react.once().to("unload");
	var originalName = thisCommand_obj.sprite._name;
	// if(duration==0)
	// 	duration = 0.001;
	// add slideX and slideY variables into the affected sprite
	var slideX = thisCommand_obj.sprite.slideX = new mx.transitions.Tween( thisCommand_obj.sprite, "_x", null, startX, endX, duration, true);
	var slideY = thisCommand_obj.sprite.slideY = new mx.transitions.Tween( thisCommand_obj.sprite, "_y", null, startY, endY, duration, true);
	slideY.thisCommand_obj = thisCommand_obj;
	
	var motionDone = function( thisTween )
	{
		react_to_unload.disable();
		//var spriteRemoved = (!sameSprite  ||  thisCommand_obj.sprite.wasRemoved  ||  thisCommand_obj.sprite._name == undefined  ||  thisCommand_obj.sprite._name == "");
		var sameSprite = thisCommand_obj.sprite == SPRITES[originalName];
		var spriteRemoved = (!sameSprite);
		var wasMoving = Boolean(slideX.onMotionFinished);
		slideX.onMotionFinished = null;
		slideY.onMotionFinished = null;
		
		// clean-up tween object
		slideX.stop();
		slideY.stop();
		delete slideX;
		delete slideY;
		delete thisCommand_obj.sprite.slideX;
		delete thisCommand_obj.sprite.slideY;
		
		if( !spriteRemoved )
		{// if:  sprite still exists
			if(thisCommand_obj.data.autoAnim)		// ON
				thisCommand_obj.sprite.image.setParams({isAnimating:false});
			if(wasMoving)		thisCommand_obj.sprite.broadcastMessage("onMoveFinish");
		}// if:  sprite still exists
		
		// check timeout before continuing
		var timeoutExists = thisCommand_obj.moveTimeout.exists( thisCommand_obj.timeout );
		if( timeoutExists )
		{// if:  timeout hasn't been deleted
			// clearTimeout
			thisCommand_obj.moveTimeout.remove( thisCommand_obj.timeout );
			// run next command
			if(!spriteRemoved)
				nextEvent();
			else
				prom.doBreak();		// thisCommand_obj.abort();
		}// if:  timeout hasn't been deleted
		else{
			// if:  timeout is missing
			prom.doBreak();		// thisCommand_obj.abort();
		}
	}// motionDone()
	motionDone = once( motionDone );
	//slideX.onMotionFinished = motionDone;
	slideY.onMotionFinished = motionDone;
	react_to_unload.then = motionDone;
	
	
	
	// allow motion to be interrupted  (occurs during teleports for instance)
	slideY.onMotionChanged = function()
	{
		var thisCommand_obj = this.thisCommand_obj;
		//thisCommand_obj.sprite.gridCollide_obj.loop();	// update grid position
		thisCommand_obj.sprite.broadcastMessage("onMove", {x:thisCommand_obj.sprite._x, y:thisCommand_obj.sprite._y, sprite:thisCommand_obj.sprite});
		var timeoutExists = thisCommand_obj.moveTimeout.exists( thisCommand_obj.timeout );
		//var spriteRemoved = (!sameSprite  ||  thisCommand_obj.sprite.wasRemoved  ||  thisCommand_obj.sprite._name == undefined  ||  thisCommand_obj.sprite._name == "");
		var sameSprite = thisCommand_obj.sprite == SPRITES[originalName];
		var spriteRemoved = (!sameSprite);
		if(spriteRemoved)
			thisCommand_obj.sprite.resetToStartPosition();
		if( spriteRemoved || !timeoutExists ){
			motionDone( this );
		}
	}// during move()
	
	
	
	// wait a moment
	var dudFunction = function(){};
	var waitTime = duration*1000;		// convert seconds to milliseconds
	thisCommand_obj.timeout = setTimeout( dudFunction, waitTime, thisCommand_obj );		// artifically generate a timeout ID,  and internally store it
	thisCommand_obj.moveTimeout.addTimeout( thisCommand_obj.timeout );		// externally store wait timeout
	//thisCommand_obj.moveTimeout = thisCommand_obj.sprite.moveTimeout;		// allow this command to store its timeouts
	
	
	
	// wait for promise
	return prom;


}// define_moveRelative()